$(document).ready(function() {
    // Initialize tooltips
    $('[data-bs-toggle="tooltip"]').tooltip();
    
    <?php if ($has_data): ?>
    // Initialize DataTables only if data exists
    $('#walletTable').DataTable({
        dom: "<'row'<'col-sm-12 col-md-6'B><'col-sm-12 col-md-6'f>>" +
             "<'row'<'col-sm-12'tr>>" +
             "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        buttons: [
            {
                extend: 'copy',
                className: 'btn btn-outline-primary btn-sm rounded-pill',
                text: '<i class="fas fa-copy me-1"></i> Copy'
            },
            {
                extend: 'excel',
                className: 'btn btn-outline-success btn-sm rounded-pill',
                text: '<i class="fas fa-file-excel me-1"></i> Excel'
            },
            {
                extend: 'pdf',
                className: 'btn btn-outline-danger btn-sm rounded-pill',
                text: '<i class="fas fa-file-pdf me-1"></i> PDF'
            },
            {
                extend: 'print',
                className: 'btn btn-outline-info btn-sm rounded-pill',
                text: '<i class="fas fa-print me-1"></i> Print'
            }
        ],
        responsive: true,
        pageLength: 10,
        lengthMenu: [[5, 10, 25, 50, -1], [5, 10, 25, 50, "All"]],
        order: [[0, 'asc']],
        language: {
            search: "<i class='fas fa-search'></i>",
            searchPlaceholder: "Search transactions...",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ entries",
            infoEmpty: "Showing 0 to 0 of 0 entries",
            infoFiltered: "(filtered from _MAX_ total entries)",
            zeroRecords: "No matching records found",
            paginate: {
                first: "<i class='fas fa-angle-double-left'></i>",
                last: "<i class='fas fa-angle-double-right'></i>",
                next: "<i class='fas fa-angle-right'></i>",
                previous: "<i class='fas fa-angle-left'></i>"
            }
        },
        initComplete: function() {
            // Custom styling after initialization
            $('.dataTables_filter input').addClass('form-control luxury-input');
            $('.dataTables_length select').addClass('form-select luxury-input');
        }
    });
    <?php else: ?>
    // Style the table even when no data
    $('#walletTable').addClass('no-data-table');
    <?php endif; ?>
});