<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

// ==================== PAYMENT PROCESS ====================

if (isset($_POST['amount']) && !empty($_POST['amount'])) {

    $amount = mysqli_real_escape_string($tng_conn, $_POST['amount']);
    $email  = mysqli_real_escape_string($tng_conn, $_POST['email']);
    $phone  = mysqli_real_escape_string($tng_conn, $_POST['phone']);
    $mode   = $_POST['mode'];


    // ---------------- ONLINE PAYMENT MODE ----------------
    if ($mode == "pay_online") {
        ?>
        <form method="post" name="f2" action="../Gatway/index.php">
            <input type="hidden" name="email" value="<?= $udata['email'] ?>">
            <input type="hidden" name="userid" value="<?= $udata['id'] ?>">
             <input type="hidden" name="phone" value="<?= $udata['phone'] ?>">
            <input type="hidden" name="amount" value="<?= $amount ?>">
        </form>

        <script>
            document.f2.submit();
        </script>
        <?php
    }

}   // <-- THIS was missing!

// ==================== SWEET ALERT MESSAGES ====================

$alerts = [
   
    'success'    => ['Payment Added Successfully', 'Your Payment Added!', 'success'],
    'failed'     => ['Payment Failed', 'If amount deducted, contact support!', 'error'],

];

foreach ($alerts as $key => $msg) {
    if (isset($_POST[$key]) && $_POST[$key] == "true") {
        ?>
        <script>
            $(function () {
                Swal.fire('<?= $msg[0] ?>', '<?= $msg[1] ?>', '<?= $msg[2] ?>');
            });
        </script>
        <?php
    }
}

?>




<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<style>
.wallet-card{border-radius:16px}
.wallet-balance{
 background:linear-gradient(135deg,#4e54c8,#8f94fb);
 color:#fff
}
.wallet-balance h2{font-weight:700}
.badge-success{background:#28a745}
.badge-failed{background:#dc3545}
.timer{font-size:14px;color:#555;margin-top:6px}
.table td{vertical-align:middle}
</style>

<div class="page-wrapper">
<div class="page-content">

<!-- ===== BALANCE + ADD ===== -->
<div class="row mb-4">
 <div class="col-md-6">
  <div class="card wallet-card wallet-balance shadow">
   <div class="card-body">
    <h6>Wallet Balance</h6>
    <h2>₹<?php echo number_format($udata['balance'] ?? 0, 2); ?></h2>
    <small>Mobile: <?= $udata['phone'] ?></small>
   </div>
  </div>
 </div>



 <div class="col-md-6">
  <div class="card wallet-card shadow">
   <div class="card-body">
    <h6>Add💳Money</h6>
     <form method="POST" action=""  autocomplete="off">
     <div class="input-group input-group-lg">
      <span class="input-group-text">₹</span>
      <input type="number"
       name="amount"
       class="form-control"
       min="249"
       placeholder="Enter amount (Minimum ₹249)"
       required>
       
                    <input type="hidden" name="email" value="<?= $udata['email'] ?>">
                    <input type="hidden" name="mode" value="pay_online">
     <button type="submit" class="btn btn-primary">
        <i class="fa fa-plus"></i> Add
      </button>
     </div>
     <small class="text-muted">
       Minimum recharge amount ₹249
     </small>
    </form>
   </div>
  </div>
 </div>
</div>


           
 <!-- ==================== PAYMENT LIST ==================== -->

        <h6 class="mt-4">Payment List</h6>
        <hr>

        <div class="card">
            <div class="card-body">
                <table id="example2" class="table table-striped table-bordered">
                    <thead class="table-dark">
                        <tr>
                            <th>#</th>
                            <th>Mobile</th>
                            <th>UTR</th>
                            <th>Amount</th>
                          
                            <th>Method</th>
                            <th>Status</th>
                            <th>Date</th>
                        </tr>
                    </thead>
        <tbody>
<?php
if ($udata['type'] == 'admin') {
    $res = mysqli_query($tng_conn, "SELECT * FROM wallet ORDER BY txn_date DESC");
} else {
    $phone = mysqli_real_escape_string($tng_conn, $udata['phone']);
    $res = mysqli_query($tng_conn, "SELECT * FROM wallet WHERE phone='$phone' ORDER BY txn_date DESC");
}

$srNo = 1;

if ($res && mysqli_num_rows($res) > 0) {
    while ($row = mysqli_fetch_assoc($res)) {

        // simple status
        $isSuccess = ($row['status'] === 'success');
        ?>
        <tr class="luxury-table-row">
            <!-- SR NO -->
            <td class="text-center">
                <span class="luxury-sr-badge"><?= $srNo ?></span>
            </td>
            

             <!-- num -->
            <td>
                <div class="d-flex align-items-center">
                    <i class="fas fa-receipt text-primary me-2"></i>
                    <code class="luxury-utr">
                        <?= htmlspecialchars($row['phone'] ?? '-') ?>
                    </code>
                </div>
            </td>

            <!-- UTR -->
            <td>
                <div class="d-flex align-items-center">
                    <i class="fas fa-receipt text-primary me-2"></i>
                    <code class="luxury-utr">
                        <?= htmlspecialchars($row['BANKTXNID'] ?? '-') ?>
                    </code>
                </div>
            </td>

            <!-- AMOUNT -->
            <td class="text-end">
                <div class="d-flex align-items-center justify-content-end">
                    <span class="luxury-amount">
                        ₹<?= number_format($row['amount'] ?? 0, 2) ?>
                    </span>
                    <i class="fas fa-indian-rupee-sign text-success ms-2"></i>
                </div>
            </td>

            <!-- PAYMENT MODE -->
            <td>
                <span class="badge bg-info">
                    <?= htmlspecialchars($row['PAYMENTMODE'] ?? 'ONLINE') ?>
                </span>
            </td>

            <!-- STATUS -->
            <td class="text-center">
                <span class="badge bg-<?= $isSuccess ? 'success' : 'danger' ?>">
                    <?= htmlspecialchars($row['status'] ?? 'failed') ?>
                </span>
            </td>

            <!-- DATE -->
            <td>
                <small><?= htmlspecialchars($row['txn_date'] ?? '') ?></small>
            </td>
        </tr>
        <?php
        $srNo++;
    }
} else {
    ?>
    <tr>
        <td colspan="6" class="text-center py-4 text-muted">
            <i class="fas fa-inbox"></i><br>
            No Transactions Found
        </td>
    </tr>
    <?php
}
?>
</tbody>


              </table>
            </div>
        </div>

    </div>
</div>
<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<link rel="stylesheet" href="../template/tngweb/assets/plugins/metismenu/css/wallet.css">
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>

<script>
    $(document).ready(function () {
        $('#example2').DataTable({
            lengthChange: false,
            buttons: ['copy', 'excel', 'pdf', 'print']
        });
    });
</script>

<?php include('../template/tngweb/footer.php'); ?>

<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>