<?php
@include('../includes/config.php'); 
mysqli_set_charset($tng_conn, "utf8mb4"); 

if (isset($_GET['voterautoid'], $_GET['type'])) {

        $voterautoid = intval(base64_decode($_GET['voterautoid']));
    $type = base64_decode($_GET['type']);

    // Fetch DB record
    $sql = "SELECT * FROM `voterauto1` WHERE voterautoid = '$voterautoid' LIMIT 1";
    $result = mysqli_query($tng_conn, $sql);
    if (!$result || mysqli_num_rows($result) == 0) {
        die("No record found");
    }
    $data = mysqli_fetch_assoc($result);

    // API call
    $postData = [
        "data_base64" => base64_encode(json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)),
        "type" => $type
    ];

    $ch = curl_init($Urlvoter_pdf);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $postData,
    ]);
    $response = curl_exec($ch);
    $curlError = curl_error($ch);
    curl_close($ch);

    if ($curlError) {
        die("Curl Error: " . $curlError);
    }

    
    $resData = json_decode($response, true);
    if (!$resData || empty($resData['pdf'])) {
        die("Invalid response from API");
    }

    
    $pdfBase64 = preg_replace('/^data:application\/pdf;base64,/', '', $resData['pdf']);
    $pdfContent = base64_decode($pdfBase64);

    if ($pdfContent === false || strlen($pdfContent) < 100) {
        die("Failed to decode PDF or PDF too small");
    }

    
    $filename = preg_replace('/[^a-zA-Z0-9_\-\.]/', '_', $resData['file_name'] ?? "Voter_$voterautoid") . ".pdf";

    
    if (ob_get_length()) {
        ob_end_clean();
    }

    
    header('Content-Type: application/pdf');
    header('Content-Disposition: inline; filename="' . $filename . '"'); // Changed here
    header('Content-Length: ' . strlen($pdfContent));
    header('Cache-Control: private, max-age=0, must-revalidate');
    header('Pragma: public');

    
    echo $pdfContent;
    exit;
} else {
    die("Missing voterautoid or type");
}
?>
