<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');
$fee    = $udata['voter_mobile_link_a'];
checkServiceStatus($udata, 'voter_mobile_link_a_status');
$appliedby = $udata['phone'];
$debit_fee = $udata['balance'] - $fee;
$balance = $udata['balance'];

$resdata = [];
$showOtpForm = false;
$mobileNumber = '';
$epic = '';
$otp = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $mobileNumber = trim($_POST['mobileNumber'] ?? '');
    $epic         = trim($_POST['epic'] ?? '');
    $otp          = trim($_POST['otp'] ?? '');

    
    if (!empty($mobileNumber) && empty($otp) && empty($epic)) {
        $request = [
            'mob_number' => $mobileNumber,
        ];

        $resdata = voter_link_otp_verification_api_run($request);

        if (!empty($resdata['Message']) && $resdata['Message'] === 'Failed') {
            $errorMsg = htmlspecialchars($resdata['error'] ?? "Request Failed");
            echo "<script>Swal.fire({ icon: 'error', title: 'Error', text: '$errorMsg', timer: 4000 });</script>";
        } elseif (!empty($resdata['sampleCode']) && $resdata['sampleCode'] === "200") {
            $showOtpForm = true;
            echo "<script>Swal.fire({ icon: 'success', title: 'OTP Sent', text: 'OTP sent successfully to $mobileNumber', timer: 2500 });</script>";
        }
    }

   
    if (!empty($epic) && !empty($otp)) {
        if ($balance >= $fee) {
            $request = [
                'mob_number' => $mobileNumber,
                'epic'       => $epic,
                'otp'        => $otp
            ];

            $resdata = voter_mob_link_verification_api_run($request);

            if (!empty($resdata['Message']) && $resdata['Message'] === 'Failed') {
                $errorMsg = htmlspecialchars($resdata['error'] ?? "Verification Failed");
                echo "<script>Swal.fire({ icon: 'error', title: 'Verification Failed', text: '$errorMsg', timer: 4000 });</script>";
            } elseif (!empty($resdata['sampleCode']) && $resdata['sampleCode'] === "200") {
                // ✅ Wallet debit & commission
                $parentPhone = $udata['parent'] ?? null;
                addCommission($tng_conn, $appliedby, $fee, $parentPhone, "Voter 2 Mobile Link With Otp Verification");

                mysqli_query($tng_conn, "UPDATE users SET balance=balance-$fee WHERE phone='$appliedby'");
                mysqli_query($tng_conn, "INSERT INTO `wallethistory`(`userid`, `amount`, `balance`, `purpose`, `status`, `type`) 
                    VALUES ('$appliedby','$fee','$debit_fee','Voter 2 Mobile Link With Otp Verification','1','Debit')");

            $epic  = mysqli_real_escape_string($tng_conn, $resdata['epic_number']);
$mobile = mysqli_real_escape_string($tng_conn, $resdata['mob_number']);
$fullname = mysqli_real_escape_string($tng_conn, $resdata['fullname']); 
$state = mysqli_real_escape_string($tng_conn, $resdata['state']);
$application = mysqli_real_escape_string($tng_conn, $resdata['application_no']);
$status = mysqli_real_escape_string($tng_conn, $resdata['status']);
$remark = mysqli_real_escape_string($tng_conn, $resdata['message']);
$appliedby = mysqli_real_escape_string($tng_conn, $appliedby);
$fee = mysqli_real_escape_string($tng_conn, $fee);

mysqli_query($tng_conn, "
    INSERT INTO voter_mobile_link_log
    (epic, mobile, fullname, state, fee, application, phone, status, remark)
    VALUES
    ('$epic', '$mobile', '$fullname', '$state', '$fee', '$application', '$appliedby', '$status', '$remark')
");


                echo "<script>Swal.fire({ icon: 'success', title: 'Verification Successful', text: 'Voter Mobile Linked Successfully!', timer: 3000 });</script>";
            }
        } else {
            // ✅ Wallet Low case
            echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>";
            echo "<script>Swal.fire({ icon: 'error', title: 'Wallet Low', text: 'Please Recharge Now!', timer: 2500 });setTimeout(() => { window.location = 'wallet.php'; }, 2000);</script>";
        }
    }
}
?>


<!-- HTML Part -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<div class="content-wrap">
 <div class="main">
  <div class="page-wrapper">
    <div class="page-content">
      <div class="mobile-menu-overlay"></div>
      <div class="main-container">
        <div class="col-lg-12">
          <div class="card" style="margin-left: 10px; padding-left: 30px; padding-top: 12px; box-shadow: 1px 5px 5px 5px;">
            <div class="stat-widget-two">
              <div class="stat-content">
                <div class="stat-text">
                  <div class="container-fluid">
                    <div class="row">
                      <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="card">
                          <div class="card-body">
                                  <div class="mb-4">
        <a href="javascript:history.back()" class="back-btn">
            <i class="bi bi-arrow-left-circle"></i> Go Back
        </a>
    </div>
                            <div class="alert alert-info" role="alert">
                              Voter Mobile Link Instant Without OTP Verification
                            </div>
                            <form action="" method="POST" class="row g-3">
                              <div class="card-body">
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <label for="mobileNumber">Enter Mobile Number</label>
                                    <input name="mobileNumber" type="text" id="mobileNumber" placeholder="Enter Mobile Number" value="<?= htmlspecialchars($mobileNumber) ?>" class="form-control" required>
                                  </div>
                                </div>
                              </div>

                              <?php if ($showOtpForm): ?>
                              <div class="card-body">
                                <div class="form-group mt-2">
                                  <label for="epic">Enter Voter Number</label>
                                  <input name="epic" type="text" id="epic" placeholder="Enter Voter Number" class="form-control" required>
                                </div>
                                <div class="form-group mt-2">
                                  <label for="otp">Enter OTP</label>
                                  <input name="otp" type="text" id="otp" placeholder="Enter OTP" class="form-control" required>
                                </div>
                              </div>
                              <?php endif; ?>

                              <hr>
                              <div class="row mt-3">
                                <div class="col-md-6">
                                  <input class="form-control" value="Fee ₹ <?= $fee ?>" readonly>
                                </div>
                                <div class="col-md-6 text-end">
                                  <button class="btn btn-primary" name="submit" id="submit"><i class="fa fa-check-circle"></i> Submit</button>
                                </div>
                              </div>
                            </form>
                          </div>
                        </div>
                      </div>

                      <?php if (!empty($resdata['sampleCode']) && $resdata['sampleCode'] === "200" && !empty($resdata['epic_number'])): ?>
                      <div class="col-lg-8 col-md-6 col-sm-6">
                        <div class="card" style="background-color: #E8F6F3;">
                          <div class="card-body">
                              <a href="voter_mobile_link_list.php" class="btn btn-info">
        <i class="fa fa-list"></i> Go To List
    </a>
                            <h5 class="mb-3">Voter Mobile Link Result</h5>
                            <table class="table table-bordered table-striped">
                              <tbody>
                                <tr><th>Voter Number</th><td><?= htmlspecialchars($resdata['epic_number']) ?></td></tr>
                                <tr><th>Mobile Number</th><td><?= htmlspecialchars($resdata['mob_number']) ?></td></tr>
                                <tr><th>Name</th><td><?= htmlspecialchars($resdata['fullname']) ?></td></tr>
                                <tr><th>Reference Number</th><td><?= htmlspecialchars($resdata['referenceNumber']) ?></td></tr>
                                <tr><th>State Name</th><td><?= htmlspecialchars($resdata['state']) ?></td></tr>
                                <tr><th>Message</th><td><?= htmlspecialchars($resdata['message']) ?></td></tr>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>
                      <?php endif; ?>

                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <br><br><br><br>
        </div>
      </div>
    </div>
  </div>
</div>

<?php include('../template/tngweb/footer.php'); ?>
<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
</html>