<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$appliedby = $udata['phone'];

if ($udata['type'] == 'admin') {
    $res = mysqli_query($tng_conn, "SELECT name, mobile, email, gender, application_type, application_mode, phone, p_order_id, status, ack_no, date FROM nsdl_requests ORDER BY id DESC");
} else {
    $res = mysqli_query($tng_conn, "SELECT name, mobile, email, gender, application_type, application_mode, phone, p_order_id, status, ack_no, date FROM nsdl_requests WHERE phone='$appliedby' ORDER BY id DESC");
}
?>

<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="card radius-15 shadow-lg border-0">
      <div class="card-body">
        <!-- Back Button -->
        <div class="d-flex align-items-center justify-content-between mb-3">
          <a href="javascript:void(0);" onclick="window.history.back();" class="btn btn-outline-primary rounded-pill px-4 py-2 fw-semibold">
            <i class="bi bi-arrow-left-circle me-2"></i> Go Back
          </a>
          <h5 class="mb-0 fw-bold text-primary">💰 All NSDL PAN History</h5>
        </div>
        <hr>

        <div class="table-responsive">
          <table id="walletTable" class="table table-hover table-striped align-middle text-center">
            <thead class="table-dark">
              <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Mobile</th>
                            <th>Email</th>
                            <th>Gender</th>
                            <th>Application </th>
                            <th> Order ID</th>
                            <th>Status</th>
                            <th>Ack No</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $x = 0;
                        while($data = mysqli_fetch_assoc($res)){
                            $x++;
                            // status badge
                            $statusBadge = "<span class='badge bg-secondary'>{$data['status']}</span>";
                            if ($data['status'] == 'SUCCESS') {
                                $statusBadge = "<span class='badge bg-success'>Success</span>";
                            } elseif ($data['status'] == 'Pending') {
                                $statusBadge = "<span class='badge bg-warning text-dark'>Pending</span>";
                            } elseif ($data['status'] == 'REFUNDED') {
                                $statusBadge = "<span class='badge bg-danger'>Refunded</span>";
                            }

                            echo "<tr>
                                <td>{$x}</td>
                                <td>{$data['name']}</td>
                                <td>{$data['mobile']}</td>
                                <td>{$data['email']}</td>
                                <td>{$data['gender']}</td>
                                <td>{$data['application_type']} <span class='text-muted'>({$data['application_mode']})</span></td>
                                <td>{$data['p_order_id']}</td>
                                <td>{$statusBadge}</td>
                                <td>{$data['ack_no']}</td>
                                <td>".date("d-M-Y h:i A", strtotime($data['date']))."</td>
                            </tr>";
                        }
                        ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!--end page wrapper -->

<?php include('../template/tngweb/footer.php'); ?>

<!-- ✅ DataTables CDN & Scripts -->
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>


<script>
  $(document).ready(function() {
    $('#walletTable').DataTable({
      lengthChange: false,
      pageLength: 10,
      order: [[0, "desc"]],
      buttons: ['copy', 'excel', 'pdf', 'print'],
      dom: '<"d-flex justify-content-between align-items-center mb-3"Bf>rt<"d-flex justify-content-between align-items-center"ip>'
    });
  });
</script>

<style>
  /* 🌟 Stylish Table */
  .table thead th {
    vertical-align: middle;
    font-weight: 600;
    letter-spacing: 0.3px;
  }

  .table tbody tr:hover {
    background: #f5f8ff;
    transition: 0.2s ease;
  }

  .card {
    background: #fff;
    border-radius: 15px;
  }

  .btn-outline-primary {
    border-color: #0055ff;
    color: #0055ff;
  }

  .btn-outline-primary:hover {
    background-color: #0055ff;
    color: #fff;
  }

  .dataTables_wrapper .dataTables_filter input {
    border-radius: 8px;
    padding: 5px 10px;
  }

  .dataTables_wrapper .dataTables_paginate .paginate_button {
    border-radius: 5px;
  }

  .dataTables_wrapper .dt-buttons .btn {
    border-radius: 20px !important;
    font-size: 0.85rem;
    margin-right: 6px;
  }

  .badge {
    font-size: 0.8rem;
    padding: 6px 10px;
  }
</style>