<?php
ob_start(); // 🔴 VERY IMPORTANT (PDF header fix)

include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['Vehicle_pdf_fee'] ?? 30;
checkServiceStatus($udata, 'Vehicle_pdf_fee_status');

if (isset($_POST['rcno'], $_POST['rctype'])) {

    $rcno = trim($_POST['rcno']);
    $rctype = $_POST['rctype'];
    $appliedby = $udata['phone'];
    $debit_fee = $udata['balance'] - $fee;

    if ($udata['balance'] < $fee) {

        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire({
                icon:'error',
                title:'Wallet Balance is Low!',
                text:'Please Recharge Now!'
            });
            setTimeout(() => { window.location = 'wallet.php'; }, 1200);
        </script>";

    } else {

        $request = [
            'rcno'   => $rcno,
            'rctype'=> $rctype,
        ];

        $resdata = vehicle_rcpdf_verification_api_run($request);

        /* ===== FAILURE CASE ===== */
        if (
            empty($resdata) ||
            $resdata['status'] !== true ||
            $resdata['StatusCode'] !== '200'
        ) {

            $errorMsg = $resdata['message'] ?? 'Something went wrong';

            echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
            <script>
                Swal.fire({
                    icon:'error',
                    title:'Error',
                    text:'$errorMsg',
                    timer:5000
                });
            </script>";

        }

        /* ===== SUCCESS CASE ===== */
        else {

            date_default_timezone_set('Asia/Kolkata');
            $timestamp = date("Y-m-d H:i:s");

            $parentPhone = $udata['parent'] ?? null;
            addCommission($tng_conn, $appliedby, $fee, $parentPhone, "Vehicle PDF Verification");

            mysqli_query($tng_conn,
                "UPDATE users SET balance = balance - $fee WHERE phone='$appliedby'"
            );

            mysqli_query($tng_conn,
                "INSERT INTO wallethistory(userid,amount,balance,purpose,status,type)
                 VALUES('$appliedby','$fee','$debit_fee',
                 'Vehicle PDF Verification','1','Debit')"
            );

            mysqli_query($tng_conn, "INSERT INTO vehicle_pdf(name, username, aadhar, pdf, date) VALUES 
            ('{$resdata['name']}','{$udata['phone']}','{$resdata['rcno']}','{$resdata['pdf']}','$timestamp')"
            );
$doDownload = isset($_POST['download_pdf']);
           if ($doDownload && !empty($resdata['pdf'])) {

    $pdfBinary = base64_decode($resdata['pdf']);
    $filename = "RC_PDF_".$rcno.".pdf";

    ob_clean();
    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="'.$filename.'"');
    header('Content-Length: '.strlen($pdfBinary));

    echo $pdfBinary;
    exit;
}
        }
    }
}

ob_end_flush();
?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<div class="content-wrap">
 <div class="main">
<div class="page-wrapper">
    <div class="page-content">
        <div class="mobile-menu-overlay"></div>
        <div class="main-container">
            <div class="col-lg-12">
                <div class="card" style="margin-left: 10px; padding-left: 30px; padding-top: 12px; box-shadow: 1px 5px 5px 5px;">
                    <div class="stat-widget-two">
                        <div class="stat-content">
                            <div class="stat-text">
                                <div class="container-fluid">
                                    <div class="row">
                                        <div class="col-lg-4 col-md-6 col-sm-6">
                                            <div class="card">
                                                <div class="card-body">
                                                        <div class="mb-4">
        <a href="javascript:history.back()" class="back-btn">
            <i class="bi bi-arrow-left-circle"></i> Go Back
        </a>
    </div>
                                                    <div class="alert alert-info" role="alert">
                                                         Vehicle PDF Verification
                                                    </div>
                                                    <form action="" method="POST" class="row g-3">
                                                        <div class="card-body">
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label for="rcno">Enter Vehicle Number</label>
                                                                    <input name="rcno" type="text" id="rcno" placeholder="Enter Vehicle Number" class="form-control" required>
                                                                </div>
                                                                
                                                                <div class="form-group mt-2">
                                                                    <label for="rctype">Select Vehicle Type</label>
                                                                    <select name="rctype" class="form-control" required>
                                                                        <option value="">Select Vehicle Type</option>
                                                                        <option value="1"> Chip</option>
                                                                        <option value="2">Without Chip</option>
                                                                        <option value="4"> Chip New</option>
                                                                        <option value="3">Without Chip New</option>
                                                                    </select>
                                                                </div>
                                                                <hr>
                                                                <div class="row mt-3">
                                                                  <div class="col-md-6">
                                                                       <input class="form-control" value="Fee ₹ <?php echo $fee; ?>" readonly>
                                                                   </div>
                                                                   <div class="col-md-6 text-end">
                                                                       <button class="btn btn-primary" name="submit" id="submit"><i class="fa fa-check-circle"></i> Submit</button>
                                                                   </div>
                                                               </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
<?php if (!empty($resdata) && $resdata['StatusCode'] === '200') { ?>
<div class="col-lg-8 col-md-6 col-sm-6">
    <div class="card" style="background-color:#E8F6F3;">
        <div class="card-body">

<h5>
Vehicle To Pdf Verification
<a href="Vehicle_Rc_pdf_list.php"
   style="font-size:14px;margin-left:10px;color:blue;">
(View List)
</a>
</h5>

<table class="table table-bordered table-striped">
<tr>
<th>Vehicle Number</th>
<td><?=htmlspecialchars($resdata['rcno'])?></td>
</tr>

<tr>
<th>Name</th>
<td><?=htmlspecialchars($resdata['name'])?></td>
</tr>

<tr>
<th>Message</th>
<td><?=htmlspecialchars($resdata['message'])?></td>
</tr>

<tr>
<th>PDF</th>
<td>
<form method="POST" style="display:inline;">
    <input type="hidden" name="rcno" value="<?=htmlspecialchars($resdata['rcno'])?>">
    <input type="hidden" name="rctype" value="<?=htmlspecialchars($_POST['rctype'])?>">
    <input type="hidden" name="download_pdf" value="1">
    <button class="btn btn-success btn-sm">
        Download PDF
    </button>
</form>
</td>
</tr>
</table>

        </div>
    </div>
</div>
<?php } ?>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <br><br><br><br>
            </div>
        </div>
    </div>
</div>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const form = document.querySelector("form");
    const submitBtn = document.getElementById("submit");

    let isSubmitting = false;

    form.addEventListener("submit", function (e) {
        if (isSubmitting) {
            e.preventDefault();
            return;
        }
        isSubmitting = true;      
        submitBtn.disabled = true; 
    });
});
</script>
<?php include('../template/tngweb/footer.php'); ?>
<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
</html>
