<?php
require_once('../includes/session.php');
require_once('../includes/config.php');
require_once('lib/AhkWebCheckSum.php');
$api_json      = get_api_json($tng_conn);
$payment_json_raw = $api_json['payment_json'] ?? [];

// Agar JSON string hai to decode karo
if (is_string($payment_json_raw)) {
    $payment_json = json_decode($payment_json_raw, true) ?? [];
} elseif (is_array($payment_json_raw)) {
    $payment_json = $payment_json_raw;
} else {
    $payment_json = [];
}


if(isset($_POST['amount']) && !empty($_POST['amount'])){

    // POST values sanitize
    $amount    = mysqli_real_escape_string($tng_conn, $_POST['amount']);
    $email     = mysqli_real_escape_string($tng_conn, $_POST['email']);
    $userid    = mysqli_real_escape_string($tng_conn, $_POST['userid']);
    $phone    = mysqli_real_escape_string($tng_conn, $_POST['phone']);


    // Unique order id
    $orderId = "Add_wallet_" . uniqid();
    $txnAmount = $amount;
    $txnNote   = $email;
    $callback_url = "https://nehaprint.shop/Gatway/txnResult.php";

// Final variables
$AHKWEB_TXN_URL = trim($payment_json['gateway_Url'] ?? '');
$upiuid        = trim($payment_json['gateway_upi'] ?? '');
$token         = trim($payment_json['gateway_token'] ?? '');
$secret        = trim($payment_json['gateway_secret'] ?? '');



    // Dates
    $date     = date("Y-m-d");
    $txn_date = date("Y-m-d H:i:s");

    // Insert into wallet
    $insert = mysqli_query($tng_conn, "INSERT INTO `wallet`
    (`phone`, `amount`, `txn_id`, `date`, `txn_date`, `email`, `PAYMENTMODE`, `RESPMSG`, `BANKTXNID`, `status`)
    VALUES
    ('$phone','$txnAmount','$orderId','$date','$txn_date','$email','UPI','PENDING','0','pending')");

    if(!$insert){
        die("Insert Error: " . mysqli_error($tng_conn));
    }

    // Prepare parameters for gateway
    $paramList = array(
        "upiuid"      => $upiuid,
        "token"       => $token,
        "orderId"     => $orderId,
        "txnAmount"   => $txnAmount,
        "txnNote"     => $txnNote,
        "cust_Email"  => $email,
        "cust_Mobile" => (preg_match('/^[0-9]{10}$/', $phone) ? $phone : '9999999999'),
        "callback_url"=> $callback_url
    );

    // Generate checksum
    $checkSum = AhkWebCheckSum::generateSignature($paramList, $secret);

    if($checkSum == NULL){
        die("Error: Checksum generation failed");
    }

    // Auto submit form to Gateway
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <title>Gateway Check Out Page</title>
    </head>
    <body>
        <center><h1>Please do not refresh this page...</h1></center>
        <form method="post" action="<?php echo $AHKWEB_TXN_URL ?>" name="f1">
            <?php
            foreach($paramList as $name => $value){
                echo '<input type="hidden" name="'.$name.'" value="'.$value.'">';
            }
            ?>
            <input type="hidden" name="checksum" value="<?php echo $checkSum; ?>">
        </form>
        <script type="text/javascript">
            document.f1.submit();
        </script>
    </body>
    </html>
    <?php

} else {
    die("Error: Amount not specified");
}

?>
